set Release(options.tcl) {$Header: /home/cvs/tktest/options.tcl,v 1.3 2004/09/02 14:51:04 clif Exp $}
#
# OptionBox: allow the user to set various replay options.
#
proc OptionBox {} {
    global ReplayData
    set w .replay.optionBox
    if [winfo exists $w] {
        wm deiconify $w
        raise $w
    } else {
        #
        # make the toplevel and the title
        #
        toplevel $w
        wm title $w "User Preferences"
        #
        # make a frame to hold the replay pointer options
        #
        labelframe $w.point -bd 2 -relief ridge -text "Replay Preferences"
        pack $w.point -side top -fill x  -padx 5 -pady 2
        label $w.point.info -text "Pointing to widgets"
        pack $w.point.info -side top -fill x
        checkbutton $w.point.arrow -anchor w \
            -text "Point red arrow at widgets as they are replayed" \
            -variable ReplayData(pointWithArrow)
        if $ReplayData(pointWithArrow) {
            $w.point.arrow select
        }
        pack $w.point.arrow -side top -fill x
        checkbutton $w.point.pointer -anchor w \
            -text "Move mouse pointer to widgets as they are replayed" \
            -variable ReplayData(pointWithMouse)
        if $ReplayData(pointWithMouse) {
            $w.point.pointer select
        }
        pack $w.point.pointer -side top -fill x
        #
        # make a frame to hold the mouse speed options
        #
        labelframe $w.mspeed -bd 2 -relief ridge -text "Mouse speed"
        pack $w.mspeed -side top -fill x -padx 5 -pady 2

        radiobutton $w.mspeed.ms1 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Slow" -value 1
        pack $w.mspeed.ms1 -side top -fill x
        radiobutton $w.mspeed.ms3 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Medium" -value 3
        pack $w.mspeed.ms3 -side top -fill x
        radiobutton $w.mspeed.ms6 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Fast" -value 6
        pack $w.mspeed.ms6 -side top -fill x
        radiobutton $w.mspeed.ms100 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Very fast" -value 100
        pack $w.mspeed.ms100 -side top -fill x
        radiobutton $w.mspeed.msinf -anchor w  \
            -variable ReplayData(MouseSpeed) \
            -text "Warp (infinite)" -value 2000
        pack $w.mspeed.msinf -side top -fill x
        $w.mspeed.ms3 invoke
        #
        # make the dismiss button.  Keep the window around so it will
        # come up faster next time.
        #
        button $w.dismiss -text "Dismiss" -command "wm withdraw $w"
        pack $w.dismiss  -side top
    }
}
