proc makeGrabGUI {txt lbl command} {
  catch {destroy .replay.grabFrame}

  set w [frame .replay.grabFrame -relief raised -borderwidth 5]
  set w [labelframe .replay.grabFrame.lf -text "$txt" ]

  label $w.l1 -text $lbl
  entry $w.e1 
  button $w.b1 -text "Cancel" -command {
      destroy .replay.grabFrame;
      set ReplayData(Timer) 1
      }

  button $w.b2 -text "Go" -command "\
      $command \[.replay.grabFrame.lf.e1 get\];  \
      destroy .replay.grabFrame; \
      "
  grid $w.l1 -row 1 -column 0
  grid $w.e1 -row 1 -column 1
  grid $w.b1 -row 2 -column 0
  grid $w.b2 -row 2 -column 1
  pack .replay.grabFrame.lf
  place .replay.grabFrame -relx .5 -rely .5 -anchor center
}

proc grabArrayGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get Array Snapshot" "Array Name" grabArray
}

proc grabSQLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get SQL Snapshot" "SQL CMD" grabSQL
}

proc grabTCLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Check Return of Tcl command" "TCL CMD" grabTCL
}

proc grabWindowContentsGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get Window Snapshot" "Window Name" grabWindowContents
}

proc grabWindowContents {win} {
  global ReplayData

  set contents [getContents $win]

  InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckWinReturn $win $contents] 1]
    set ReplayData(Timer) 1
}

proc getReply {cmd} {
  global ReplayData
  tkrsend $ReplayData(ConnectedApps) \
    "catch {$cmd} rpl; socksend  tktest.tcl \"set ReplayData(Reply) \[list \$rpl]\""
  vwait ReplayData(Reply)
  return $ReplayData(Reply)
}

proc getContents {win} {
  global ReplayData
  
  set type [getReply "winfo class $win"]

  set rtn "$win $type"
  switch $type {
     Tobe -
     Labelframe -
     Toplevel -
     Panedwindow -
     Frame {
        set children [getReply "winfo children $win"]
	foreach ch $children {
	  lappend rtn [getContents $ch]
	}
     }
     Label {
        lappend rtn [getReply "$win cget -text"]
     }
     Entry {
        lappend rtn [getReply "$win get"]
     }
     Canvas {
       foreach i [getReply "$win find all"] {
         lappend rtn \
	   [list $i [getReply "$win itemconfigure $i"]]
         lappend rtn \
	   [list $i [getReply "$win coords $i"]]
       }
     }
  }
  return $rtn
}

proc grabArray {arrayName} {
    global ReplayData
    set xx [getReply "array get $arrayName"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list array get $arrayName] $xx] 1]
    set ReplayData(Timer) 1
}


proc grabSQL {cmd} {
    global ReplayData
    set xx [getReply "db eval {$cmd}"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list db eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}

proc grabTCL {cmd} {
    global ReplayData
    set xx [getReply "eval $cmd"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}


proc CheckWinReturn {win expect} {
  global  ReplayData
  set contents [getContents $win]

  if {![string equal $contents $expect]} {
       set misMatch [stringDiff $contents $expect]
       set msg "Window Fail: ($ReplayData(ScriptFileName)) $win\n  $misMatch"
    } else {
       set msg "Window Check OK ($ReplayData(ScriptFileName)): $win"
    }

    MsgToUser $msg high
}

proc CheckReturn {cmd expect} {
    global ReplayData
    set xx [getReply "$cmd"]
    if {[string equal $expect $xx]} {
      set msg "Cmd Check OK ($ReplayData(ScriptFileName)): $cmd"
    } else {
      set misMatch [stringDiff $xx $expect]
      set msg "Cmd Fail ($ReplayData(ScriptFileName)): $cmd\n  $misMatch"
    }
    MsgToUser "$msg" high
}

proc stringDiff {A B} {
    if {[string equal $A $B]} {
        return "Strings Match"
    }
    set lenA [string length $A]
    set lenB [string length $B]
    set len $lenA
    if {$lenA < $lenB} {set len $lenB}
    
    set part [expr $len / 2]
    set start 0
    
    while {$part > 60} {
        if {[string equal -length $part $A $B ]} {
	    set A [string range $A $part end]
	    set B [string range $B $part end]
	    incr start $part
	} else {
	    set A [string range $A 0 $part]
	    set B [string range $B 0 $part]
	}
	set part [expr $part / 2]
    }
    return "Differ in segments starting at $start:\n  $A\n  $B"
}
